;************************************************
;
; TF-20 Speichertest
; werner.roemer@t-online.de
;
; die optionale PIO wurde fuer eine einfache Ausgabe nachgerüstet
; Kanal B = High Byte	mit LED gegen gnd
; Kanal B = Low Byte	--"--
;
;************************************************
;
; Stand:	10.02.2026	ohne Stack
;		10.02.2026	mit Stack
;
;
;	SRCBEG = Anfangsadresse
;	SRCEND = Endadresse
;	DSTBEG = Konstante
;
;stack		equ	1100h		;
srcbeg	equ	0fffh			; 1000h - 1
srcend	equ	0ffffh	      ;
;	                              ;
wert1		equ	5ah	            ; 01011010b
wert2		equ	0a5h			; 10100101b
;
;
pioa		equ	0fch			; High Byte
piob		equ	0fdh			; Low Byte
pioc		equ	0feh			; Eingabe
pios		equ	0ffh			; Steuerregister
bap1		equ	89h			; 1000 1001
;						; Kanal A Modus 0 Ausgabe,
;						; Kanal B Modus 0 Ausgabe
;						; Kanal C Eingabe
;
;
;------------------------------------------------
;
	org	0000h				;

init:		;lxi	sp,stack		;
pioini:	mvi	a,bap1		; PIO-Betriebsarten einstellen
		out	pios			;
		mvi	a,0ffh		; alle Ausgaenge auf High		;
		out	pioa			;
		out	piob			;
		out	pioc			;
		;
		lxi	h,srcbeg		;
		lxi	d,srcend		;
		mvi	b,wert1           ;
		mvi	c,wert2           ;
						;
meld0:	mov	a,l               ; Low Byte auf LED
		cma				;
		out	piob              ;
		mov	a,h               ; High Byte auf LED
		cma				;
		out	pioa              ;
		;
tloop:	inx	h
		mov	m,b               ; 1.Test
		mov	a,m               ;
		cmp	b                 ;
		jnz	fehler            ;
						;
		mov	m,c               ; 2.Test
		mov	a,m               ;
		cmp	c                 ;
		jnz	fehler            ;

comp:  	mov	a,l			; Endadresse erreicht
		cmp	e	            ;
		jnz	tloop			; ungleich, ende
		mov	a,h	            ;
		cmp	d			; gleich (Z)=1
						;
		jz	end			; fertig
		jmp	tloop             ; nein weiter
						;
ende:						;
fehler:	mov	a,l               ;
		cma				;
		out	piob              ;
		mov	a,h               ;
		cma				;
		out	pioa              ;

		hlt				;

end


