;################################
;
; Erson TF-20 BOOT-EPROM
;
; Quellcode aus 2716 disassembliert
; werner.roemer@t-online.de
;
; Stand: 08.02.2026
;
;################################
;
;
;L0003		equ	0f81eh	;
;L0004		equ	0f8b6h	;
;L0005		equ	0f8a2h	;
;L0006		equ	0fa74h	;
;L0007		equ	0fa1fh	;
;L0008		equ	0fa4ch	;
;L0009		equ	0fa55h	;
;L0010		equ	0fac4h	;
;L0011		equ	0fae9h	;
;L0012		equ	0fad2h	;
;L0013		equ	0F870h	;
;L0014		equ	0F92Dh	;
;L0015		equ	0F882h	;
L0016		equ	0DB00h	;==> BDOS ????
;L0017		equ	0F998h	;
;L0018		equ	0F931h	;
;L0019		equ	0F99Ch	;
;L0020		equ	0F8EFh	;
;L0021		equ	0F916h	;
;L0022		equ	0F8ACh	;
;L0023		equ	0F912h	;
;L0024		equ	0F91Eh	;
;L0025		equ	0F989h	;
;L0026		equ	0F97Ah	;
;L0027		equ	0FA98h	;
;L0028		equ	0F96Eh	;
;L0029		equ	0F956h	;
;L0030		equ	0F953h	;
;L0031		equ	0F936h	;
;L0032		equ	0FA09h	;
;L0033		equ	0F9B9h	;
;L0034		equ	0FA06h	;
;L0035		equ	0F9FFh	;
;L0036		equ	0F9F3h	;
;L0037		equ	0F9DBh	;
;L0038		equ	0F9D8h	;
;L0039		equ	0F9BBh	;
;L0040		equ	0F981h	;
;L0041		equ	0FA17h	;
;L0042		equ	0FA13h	;
;L0043		equ	0FA32h	;
;L0044		equ	0FA3Ah	;
;L0045		equ	0FA3Eh	;
;L0046		equ	0FA57h	;
;L0047		equ	0FA80h	;
;L0048		equ	0FADEh	;
;L0049		equ	0FAACh	;
;L0050		equ	0FAC5h	;
;L0051		equ	0FB09h	;
;
;----------------------------------------------------------
;
; ROM/RAM				f6h
; DIP Switch			f7h
; TC					f8h
;
; µPD765AC	Floppycontroller	fah..fbh
; µPD7201C	Seriell Baustein	f0h..f3h
;
; 8255		Parallel optional	fch..ffh
;
;
;
; Port Belegung
;
;
; PORTx
;   a7 a6 a5 a4 | a3 a2 a1 a0  HEX
;   1  1  1  1  | 0  0  0  0    f0  rd/wr SIO
;   .  .  .  .  | .  .  .  .    .   .     .
;   1  1  1  1  | 0  0  1  1    f3  rd/wr SIO
;   1  1  1  1  | 0  1  1  0    f6  rd	  ROM aus
;   1  1  1  1  | 0  1  1  1    f7  rd	  DIP Switch bit 0-3
;   1  1  1  1  | 1  0  0  0    f8  rd/wr TC / bit 0 = Motor ON
;   1  1  1  1  | 1  0  1  0    fa  rd	  FDC Status
;   1  1  1  1  | 1  0  1  1    fb  rd/wr FDC Daten
;
;   1  1  1  1  | 1  0  1  1    fc  PIO Kanal A optional
;   1  1  1  1  | 1  0  1  1    fd  PIO Kanal B
;   1  1  1  1  | 1  0  1  1    fe  PIO Kanal C
;   1  1  1  1  | 1  0  1  1    ff  PIO Control
;
;==========================================================
; SIO
;
; ADR	a1 a0  HEX
; PIN	B  C
;
; 	0  0    f0 Daten   Kanal A
; 	0  1    f1 Control Kanal A
; 	1  0    f2 Daten   Kanal B
; 	1  1    f3 Control Kanal B
;
;----------------------------------------------------------
; SIO CTRL Reg
;
;	0 Command/Control/RegP
;	1 INT Control		* nicht benutzt
;	2 Processorbus Interface
;	3 Receiver control
;	4 Mode Control
;	5 Transmitter Control
;	6 Synchron Adress character
;	7 Sync character
;
;
; SIO CRTL Reg0
;
;   d7 d6 | d5 d4 d3 | d2 d1 d0
;   CRC.  | Command  | Reg Point
;
;----------------------------------------------------------
;
; SystemRAM Speicherbelegung
;
; 0008h =
; 0009h	=
; 000ah =
; 000bh = | [Zieladresse
; 000ch = |  0DB00h] aus L0015
; 000dh =
; 000eh =
; 000fh	= Motor FF
; 0010h =
;
; 0019h =
; 001ah =
;
; 0100h = Stack MiniSystem
;
; 1100h = Stack für Copy-Routine
;
; 0f92ch = Zwischenspeicher für L0004 ???
;
;----------------------------------------------------------
;

  	org	0000h		;

	lxi sp,1100h		;
	nop			;
	nop                     ;
	nop                     ;
	nop                     ;
	nop                     ;
	nop                     ;
	lxi b,0100h			; Quelle
	lxi d,0f800h		; Ziel
	lxi h,0050h			; Laenge
copy:	ldax b                  ;
	stax d                  ;
	inx b                   ;
	inx d                   ;
	dcx h                   ;
	mov a,h                 ;
	ora a                   ;
	jnz copy                ;
	jmp boot		; f800h
;                               ;
;                               ;
				;
	org 0f800h		; Mini-System
;				;
boot:				;
	jmp L0003		; init
	jmp L0004               ;
	jmp L0005               ;
	jmp L0006               ;
	jmp L0007               ; Motor EIN
	jmp L0008               ; Motor OFF
	jmp L0009               ;
	jmp L0010               ;
	jmp L0011               ;
	jmp L0012               ;
;                               ;
L0003	in 0f6h			; Shadow ROM Aus
	lxi sp,0100h            ; Stack auf 0100h
	;			;
	;			; INIT SIO Kanal B
	mvi a,18h               ; Reset Chanal
	out 0f3h                ;
	mvi a,02h               ; RegP auf 02
	out 0f3h                ;
	mvi a,00h               ; Reg Pointer auf 00
	out 0f3h                ;
	mvi a,14h               ; Reset INT
	out 0f3h                ;
	mvi a,44h               ; Reset Receiver CRC
	out 0f3h                ;
	mvi a,03h               ; RegP auf 03
	out 0f3h                ;
	mvi a,0c1h              ; Reset CRC Latch
	out 0f3h                ;
	mvi a,05h               ; RegP auf 05
	out 0f3h                ;
	mvi a,68h               ; Reset CRC, DMA
	out 0f3h                ;
	mvi a,01h               ; RegP auf 01
	out 0f3h                ;
	mvi a,00h               ; RegP auf 00
	out 0f3h                ;
	;
	; Init Floppy
	;
	call L0008		; Motor OFF
	call L0007		; Track 0 erreicht
	mvi a,03h         	; Init Werte an FDC
	call L0010		; Status OK
	mvi a,8fh         	; naechster Wert
	call L0010		; Status OK
	mvi a,1bh         	;
	call L0010		; Status OK
	mvi a,0ffh              ;
	sta 0010h               ;
	mvi a,80h               ;
	sta 001ah               ;
	mvi c,00h               ;
L0013 	call L0006		;
 	cmc                     ;
 	lda 0010h               ;
 	rar                     ;
 	sta 0010h               ;
 	inr c                   ;
 	mvi a,03h               ;
 	cmp c                   ;
 	jnc L0013               ;
L0015   xra a			;
 	sta 0008h               ;
 	sta 0009h               ;
 	inr a                   ;
 	sta 000dh               ;
 	sta 000ah               ;
 	lxi h,0db00h            ;
 	shld 000bh              ;
 	call L0007		;
 	call L0014		;
 	jc L0015		;
 ;                              ;
 ; Jump extern auf DB00h        ;
 ;
 	jmp L0016		;0DB00h ????
 ;                              ;
L0005	lda 000eh		;
 	ana a                   ;
 	jz L0014		;
 	jmp L0017		;
 ;                              ;
L0022	lda 000eh		;
 	ana a                   ;
 	jz L0018		;
 	jmp L0019		;
 ;                              ;
L0004 	call L0007		;
 	lxi h,000ah             ;
 	mvi a,21h		;
 	sub m                   ;
 	lxi h,000dh             ;
 	cmp m                   ;
 	jnc L0020               ;
 	mov b,a                 ;
 	lda 000dh               ;
 	sub b                   ;
 	sta 0f92ch              ; ==============================>|
 	mov a,b                 ;                                |
 	sta 000dh               ;                                |
 	call L0020		;                                |
 	rc                      ;                                |
 	lda 000dh               ;                                |
 	mov b,a                 ;                                |
 	lda 0f92ch              ; <==============================|
 	call L0021		;                                |
 	lda 0009h               ;                                |
 	inr a                   ;                                |
 	sta 0009h               ;                                |
 	mvi a,01h               ;                                |
 	sta 000ah               ;                                |
 	jmp L0004		;                                |
;                               ;                                |
L0020 	lxi h,000ah		;                                |
	mvi a,10h               ;                                |
	sub m                   ;                                |
	jc L0005		;                                |
	inr a                   ;                                |
	lxi h,000dh             ;                                |
	cmp m                   ;                                |
	jnc L0005		;                                |
	mov b,a                 ;                                |
	push b                  ;                                |
	call L0022		;                                |
	pop b                   ;                                |
	rc                      ;                                |
	call L0023              ;                                |
	mvi a,11h               ;                                |
	sta 000ah               ;                                |
	jmp L0005               ;                                |
;                               ;                                |
L0023	lda 000dh		;                                |
	sub b                   ;                                |
L0021 	sta 000dh		;                                |
	mvi h,00h               ;                                |
	mov l,b                 ;                                |
	mvi b,08h               ;                                |
L0024	dad h                   ;                                |
	dcr b                   ;                                |
	jnz L0024               ;                                |
	xchg                    ;                                |
	lhld 000bh              ;                                |
	dad d                   ;                                |
	shld 000bh              ;                                |
	ret                     ;                                |
;                               ;                                |
	rst 7                   ; <==== von L004 manipuliert ====>
;
L0014 	lda 000dh		;
	mov b,a                 ;
L0018	call L0025		;
	mvi a,09h               ;
L0031	sta 0019h               ;
	call L0009		;
	jc L0026		;
	mvi a,20h               ;
	cmp e                   ;
	jc L0026		;
	push b                  ;
	push d                  ;
	push h                  ;
	mvi a,40h               ;
	ori 06h                 ;
	call L0010		;
	call L0027		;
	xchg                    ;
L0030 	mvi a,00h		;
	mov c,a                 ;
L0029 	ei			;
	hlt                     ;<=== wartet auf INT
	in 0fah                 ;
	ani 20h                 ;
	jz L0028                ;
	in 0fbh                 ;
	stax d                  ;
	inx d                   ;
	dcx b                   ;
	mov a,c                 ;
	ana a                   ;
	jnz L0029		;
	mov a,b                 ;
	ana a                   ;
	jnz L0030               ;
L0028 	in 0f8h			; TC = Ende DMA
 	ei                      ;
 	hlt                     ;<=== wartet auf INT
 	di                      ;
 	pop h                   ;
 	pop d                   ;
 	pop b                   ;
 	call L0011              ;
 	rnc                     ;
L0026 	lda 0019h		;
 	dcr a                   ;
 	jnz L0031               ;
L0040	call L0006		;
 	call L0008		; Motor OFF
 	stc                     ;
 	ret                     ;
;                               ;
L0025 	call L0032		;
	lda 0008h               ;
	mov c,a                 ;
	lda 0009h               ;
	mov d,a                 ;
	lhld 000bh              ;
	ret                     ;
;                               ;
L0017 	lda 000dh		;
	mov b,a                 ;
L0019	call L0025		;
	xra a                   ;
	sta 001dh               ;
	sta 001ch               ;
	call L0012              ;
	ani 40h                 ;
	jz L0033                ;
	mvi a,0fdh              ;
	sta 001dh               ;
	sta 001ch               ;
	jmp L0034		;
;                               ;
L0033	mvi a,09h               ;
L0039 	sta 0019h		;
	call L0009		;
	jc L0035		;
	mvi a,20h               ;
	cmp e                   ;
	jc L0035		;
	mvi a,40h               ;
	ori 05h                 ;
	call L0010		;
	push b                  ;
	push d                  ;
	push h                  ;
	call L0027		;
	xchg                    ;
L0038 	mvi a,00h		;
	mov c,a                 ;
L0037 	ei			;
	hlt                     ;<=== wartet auf INT
	in 0fah                 ;
	ani 20h                 ;
	jz L0036                ;
	ldax d                  ;
	out 0fbh                ;
	inx d                   ;
	dcx b                   ;
	mov a,c                 ;
	ana a                   ;
	jnz L0037		;
	mov a,b                 ;
	ana a                   ;
	jnz L0038		;
L0036	in 0f8h                 ; TC = Ende DMA
	ei                      ;
	hlt                     ;<=== wartet auf INT
	di                      ;
	pop h                   ;
	pop d                   ;
	pop b                   ;
	call L0011              ;
	rnc                     ;
L0035 	lda 0019h		;
	dcr a                   ;
	jnz L0039		;
L0034 	jmp L0040		;
;                               ;
L0032	lda 000ah               ;
	cpi 11h                 ;
	jnc L0041		;
	mov e,a                 ;
	xra a                   ;
L0042 	sta 001bh		;
	ret                     ;
;                               ;
L0041 	sui 10h			;
	mov e,a                 ;
	mvi a,04h               ;
	jmp L0042		;
;                               ;
L0007 	lda 000fh		; Motor FF laden
	ana a			;
	jnz L0043		; ON
	mvi a,01h		;
	out 0f8h		; Motor einschalten
	call L0044		; dely
	mvi a,0ffh              ;
	sta 000fh               ; Motor FF setzen
L0043 	in 0fah			; FDC-Statuslesen
	ani 10h			; Bit 4 TR0
	jnz L0043		; warten
	ret
;
L0044 	push h			; Warteschleife
	lxi h,0000h             ;
L0045 	dcx h                   ;
	nop                     ;
	nop                     ;
	nop                     ;
	nop                     ;
	nop                     ;
	nop                     ;
	mov a,l                 ;
	ora h                   ;
	jnz L0045		;
	pop h                   ;
	ret                     ;
;                               ;
L0008 	push psw		; Motor OFF
	xra a                   ;
	sta 000fh               ;
	out 0f8h                ;
	pop psw                 ;
	ret                     ;
;                               ;
L0009 	mvi a,0d0h		;
L0046 	nop                     ;
	dcr a                   ;
	jnz L0046		;
	mvi a,27h               ;
	cmp d                   ;
	rc                      ;
	push d                  ;
	mvi a,0fh               ;
	call L0010		;
	lda 001bh               ;
	ora c                   ;
	call L0010		;
	mov a,d                 ;
	call L0010		;
	jmp L0047		;
;				;
L0006 	mvi a,07h		; 07h=Kalibrieren an FDC
	call L0010		;
	mov a,c                 ; 00h = an FDC
	call L0010		;
	push d                  ;
	mvi d,00h               ;
L0047 	ei			;
	hlt			;<=== wartet auf INT
	di                      ;
	mvi a,08h               ;
	call L0010		;
	call L0048		;
	ani 0dfh                ;
	xra c                   ;
	mov e,a                 ;
	call L0048		;
	xra d                   ;
	ora e                   ;
	pop d                   ;
	rz                      ;
	stc                     ;
	ret                     ;
;                               ;
L0027 	lda 001bh		;
	ora c                   ;
	call L0010              ;
	mov a,d                 ;
	call L0010              ;
	lda 001bh               ;
	ana a                   ;
	jz L0049                ;
	mvi a,01h               ;
L0049	call L0010              ;
	mov a,e                 ;
	call L0010              ;
	mvi a,01h               ;
	call L0010              ;
	mvi a,10h               ;
	call L0010              ;
	mvi a,0eh               ;
	call L0010              ;
	mvi a,0ffh              ;
				;
L0010:  push psw		; FDC Status abfragen
L0050   in 0fah			;
        xri 80h                 ; Test Bit 7
        ani 0c0h                ; Maske
        jnz L0050               ; warten auf OK
        pop psw                 ;
        out 0fbh                ; [A] Wert an Datenregister
        ret                     ;
;                               ;
L0012   mvi a,04h		;
        call L0010              ;
        lda 001bh               ;
        ora c                   ;
        call L0010              ;
L0048   in 0fah			; Status FDC
        cma                     ;
        ani 0c0h                ;
        jnz L0048		; warten auf OK
        in 0fbh                 ; Daten abholen
        ret                     ;
  ;                             ;
L0011   push b			;
        push d                  ;
        lxi d,0011h             ;
        call L0048		;
        stax d                  ;
        inx d                   ;
        ani 0dbh                ;
        xra c                   ;
        mov c,a                 ;
        call L0048		;
        stax d                  ;
        inx d                   ;
        ora c                   ;
        mov c,a                 ;
        call L0048		;
        stax d                  ;
        inx d                   ;
        ani 73h                 ;
        ora c                   ;
        mov c,a                 ;
        mvi b,04h               ;
L0051   call L0048		;
        stax d                  ;
        inx d                   ;
        dcr b                   ;
        jnz L0051		;
        mov a,c                 ;
        ana a                   ;
        pop d                   ;
        pop b                   ;
        rz                      ;
        stc                     ;
        ret                     ;
   ;
   ;
end


